/*********************************************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	flash.h
*  :    LinXY
*  :	V2.00
*  :	2017/4/1
*  :	flash
*  ע:    
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************************************/
  /**************************************************************************************************
  * Flashʹע
  * AĿֵ
  *		1IAPEN    ----- Enable  (ʹԱ)
  *		2LVDIAPTEN----- Disable (ֹLVDֹIAP)(ʹLVD洢ʱΪDisable)  
  *
  * BԤռFlashֹ䵽Flashĵַ(ᵼ³쳣)
  *		1巽
  *		   const unsigned char _Flash_Reserve_Memory[512] @ FLASH_PAGE_n = {0};
  *		   УFLASH_PAGE_nοflashҳַ궨.
  *		   ԶԤָĵַὫ䵽õַ.
  *		2ʹ
  *		   _Flash_Reserve_MemoryֻΪԤռ䣬ûԲöκβ
  **************************************************************************************************
  */
#ifndef __HR7P202_FLASH_H_
#define __HR7P202_FLASH_H_
/* includes --------------------------------------------------------------------------------------*/
#include "common.h"
/* exported typedef ------------------------------------------------------------------------------*/

/* exported define -------------------------------------------------------------------------------*/
#define ARRAY_SIZE(a)       (sizeof(a)/sizeof(a[0]))        //!< ȡ鳤
#define false             0
#define true              1

typedef union {
	uint hWord;
	uchar  chByte[2];
}hword_to_byte_t;

typedef union {
	ulong Word;
	uchar  chByte[4];
}word_to_byte_t;
/**
  * @brief flashԶ洢ͷ붨
  * @{
  */

#define FLASH_HEAD_MARK		0x5A5A

/**
  * @}
  */

/**
  * @brief flashҳַ
  * @{
  */
#define FLASH_PAGE_0		0x0000
#define FLASH_PAGE_1		0x0200
#define FLASH_PAGE_2		0x0400
#define FLASH_PAGE_3		0x0600
#define FLASH_PAGE_4		0x0800
#define FLASH_PAGE_5		0x0A00
#define FLASH_PAGE_6		0x0C00
#define FLASH_PAGE_7		0x0E00
#define FLASH_PAGE_8		0x1000
#define FLASH_PAGE_9		0x1200
#define FLASH_PAGE_10		0x1400
#define FLASH_PAGE_11		0x1600
#define FLASH_PAGE_12		0x1800
#define FLASH_PAGE_13		0x1A00
#define FLASH_PAGE_14		0x1C00
#define FLASH_PAGE_15		0x1E00
#define FLASH_PAGE_16		0x2000
#define FLASH_PAGE_17		0x2200
#define FLASH_PAGE_18		0x2400
#define FLASH_PAGE_19		0x2600
#define FLASH_PAGE_20		0x2800
#define FLASH_PAGE_21		0x2A00
#define FLASH_PAGE_22		0x2C00
#define FLASH_PAGE_23		0x2E00
#define FLASH_PAGE_24		0x3000
#define FLASH_PAGE_25		0x3200
#define FLASH_PAGE_26		0x3400
#define FLASH_PAGE_27		0x3600
#define FLASH_PAGE_28		0x3800
#define FLASH_PAGE_29		0x3A00
#define FLASH_PAGE_30		0x3C00
#define FLASH_PAGE_31		0x3E00
#define FLASH_PAGE_32		0x4000
#define FLASH_PAGE_33		0x4200
/**
  * @}
  */

/* exported macro --------------------------------------------------------------------------------*/

/* exported variables ----------------------------------------------------------------------------*/

/* exported function prototypes ------------------------------------------------------------------*/
/**
  * @brief ûӿں
  * @note  flashд
  *        flash_option_enable(); -> option -> flash_option_disable();
  * @{
  */

/**
  * @brief   flashʹܣʹòдǰҪô˺
  * @param   none
  * @retval  none
  * @author  linxy
  * @date    2017/11/27
  * @note    
  */
void flash_option_enable(void);

/**
  * @brief   flashֹʹòдɣҪô˺
  * @param   none
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2017/11/27
  * @note    
  */
void flash_option_disable(void);

/**
  * @brief   flashҳflashֻܰҳҳַοĺ궨
  * @param   [in]page   ҳַοĺ궨
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2017/11/27
  * @note    
  */
bool flash_erase(uint page);

/**
  * @brief   flash˫ֽд룬flashÿһַݿ16bit
  * @param   [in]page         ҳַοĺ궨
  * @param   [in]page_offset  ƫƵַĳҳϵĵ32Ϊ32
  * @param   [in]hword        Ҫд
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2017/11/27
  * @note    
  */
bool flash_write_hword(uint page, uint offsetaddr, uint hword);

/**
  * @brief   flash˫ֽڶȡflashÿһַݿ16bit
  * @param   [in]page         ҳַοĺ궨
  * @param   [in]page_offset  ƫƵַĳҳϵĵ32Ϊ32
  * @param   [out]*hword      ȡݷ
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2017/11/27
  * @note    
  */
bool flash_read_hword(uint page, uint offsetaddr, uint *phword);

/**
  * @brief   flash˫ֽд룬ʹ8λд룬flashÿһַݿ16bit
  * @param   [in]page         ҳַοĺ궨
  * @param   [in]page_offset  ƫƵַĳҳϵĵ32Ϊ32
  * @param   [in]byte_h       Ҫд8λ1
  * @param   [in]byte_l       Ҫд8λ2
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2017/11/27
  * @note    
  */
bool flash_write_byte(uint page, uint offsetaddr, uchar byte_h, uchar byte_l);

/**
  * @brief   flash˫ֽڶȡʹ8λflashÿһַݿ16bit
  * @param   [in]page         ҳַοĺ궨
  * @param   [in]page_offset  ƫƵַĳҳϵĵ32Ϊ32
  * @param   [out]*byte_h     ȡص8λ1
  * @param   [out]*byte_l     ȡص8λ2 
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2017/11/27
  * @note    
  */
bool flash_read_byte(uint page, uint offsetaddr, uchar *byte_h, uchar *byte_l);

/**
  * @brief   flashԶдƽдflashʹûҪָƫƵַ
  * @param   [in]page         ҳַοĺ궨
  * @param   [in]*pdat        дݻָ
  * @param   [in]len          дݳ
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2017/11/27
  * @note    
  */
bool flash_auto_write(uint page, uchar *pdat, uint len);

/**
  * @brief   flashԶflash_auto_writeʹ
  * @param   [in]page         ҳַοĺ궨
  * @param   [out]*pdat       ݶȡָ
  * @param   [in]len          ȡݳ
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2017/11/27
  * @note    
  */
bool flash_auto_read(uint page, uchar *pdat, uint len);

/**
  * @brief   ٳʼautoramпٵַ壬ÿѰַʱ䣬ӿЧ
  * @param   [in]page         ҳַοĺ궨
  * @param   [in]page_offset  ҳַƫƣFLASH_PAGE_21Ϊ21,FLASH_PAGE_25Ϊ25,FLASH_PAGE_29Ϊ29
  * @param   [in]len          ÿδݵĳ
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2017/11/27
  * @note    
  */
bool flash_fast_auto_init(uint page, uchar page_offset, uint len);

/**
  * @brief   flashԶдƽдflashʹûҪָƫƵַ
  * @param   [in]page         ҳַοĺ궨
  * @param   [in]page_offset  ҳַƫƣFLASH_PAGE_21Ϊ21,FLASH_PAGE_25Ϊ25,FLASH_PAGE_29Ϊ29
  * @param   [in]*pdat        дݵĻָ
  * @param   [in]len          ÿδݵĳ
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2017/11/27
  * @note    
  */
bool flash_fast_auto_write(uint page, uchar page_offset, uchar *pdat, uint len);

/**
  * @brief   flashԶflash_fast_auto_writeʹ
  * @param   [in]page         ҳַοĺ궨
  * @param   [in]page_offset  ҳַƫƣFLASH_PAGE_21Ϊ21,FLASH_PAGE_25Ϊ25,FLASH_PAGE_29Ϊ29
  * @param   [out]*pdat       ȡݵĻָ
  * @param   [in]len          ÿδݵĳ
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2017/11/27
  * @note    
  */
bool flash_fast_auto_read(uint page, uchar page_offset, uchar *pdat, uint len);

/**
  * @brief   ûɵô˺ͨ鿴ȷflash˫ֽڶдǷ
  * @param   [in]page   ҳַ
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2017/11/27
  * @note    ãõ
  */
bool flash_hword_test(uint page);

/**
  * @brief   flashԶдԣͨ鿴Ƿտʼʹʱڲ
  * @param   [in]page    ҳַ
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2017/11/27
  * @note    ãҪ
  */
bool flash_auto_test(uint page);

/**
  * @brief   flashԶдԣͨ鿴Ƿտʼʹʱڲ
  * @param   [in]page         ҳַ
  * @param   [in]page_offset  ҳַƫƣFLASH_PAGE_21Ϊ21,FLASH_PAGE_25Ϊ25,FLASH_PAGE_29Ϊ29
  * @retval  true:ɹ/false:ʧ
  * @author  linxy
  * @date    2017/11/27
  * @note    
  */
bool flash_fast_auto_test(uint page, uchar page_offset);
/**
  * @}
  */
#endif
/* end of file -----------------------------------------------------------------------------------*/
